## Read argument
args<-commandArgs(TRUE)
print("begin")
print(args)
print("end")
N_index <- eval( parse(text=args[1]) )

args <- expand.grid(alpha = c(0, 0.1, 0.2, 0.3, 0.5, 0.7, 1),
                    Nrep = c(1:20))
alpha_1 <- args[N_index, 1]
rep_1 <- args[N_index, 2]

library(rstan)
load("bm/preprocess.Rdata")

stan_fit_eval <- stan("bm/ct_hmc_eval.stan", data = data,
                      iter = 1, chains = 1)
target <- function(x){
  stan_ev <- grad_log_prob(stan_fit_eval, c(x,1))
  d_log_q <- as.numeric(stan_ev)[1:p]
  log_q <- attr(stan_ev, "log_prob")
  
  return(list(log_q = log_q, d_log_q = d_log_q))
}
temper <- function(x){
  stan_ev <- grad_log_prob(stan_fit_eval, c(x,0))
  d_log_q <- as.numeric(stan_ev)[1:p]
  log_q <- attr(stan_ev, "log_prob")
  
  return(list(log_q = log_q, d_log_q = d_log_q))
}

source("temper_zigzag_hess.R")
H <- sapply(1:p, function(i) sapply(1:p, function(j) {
  max( sum(pmax(0,data$q[,i]*data$q[,j])),
       sum(pmax(0,-data$q[,i]*data$q[,j])))
}))
diag(H) <- pmax(1, abs(1 - diag(H))) + 1

theta_0 <- rep(1,p)
hess_q1 <- matrix(H%*%theta_0[1:p],  nrow = 1)
hess_q0 <- matrix(abs(solve(tcrossprod(data$chol_sigma)))%*%theta_0[1:p], nrow = 1, byrow = T)
(hess <- abs(matrix(c(hess_q0,
                      hess_q1), nrow = 2,ncol = p, byrow = T)))
rownames(hess) <- c("q0", "q1")

x_init <- data$mu
theta_init <- rep(1,p)
log_bf <- 0
iters <- 1e6

if(alpha_1 == 0){
  temper <- function(x){
    stan_ev <- grad_log_prob(stan_fit_eval, c(x,0))
    d_log_q <- as.numeric(stan_ev)[1:p]
    log_q <- attr(stan_ev, "log_prob")
    
    return(list(log_q = log_q + data_cts$log_zeta, d_log_q = d_log_q))
  }
  set.seed(N_index);zigzag_fit <- zigzag_temp(max_events = iters,
                                              x0 = c(x_init,.1),
                                              theta0 = c(theta_init,1),
                                              alphas = c(0, alpha_1), tau_max = 1,
                                              poly_order = 3, echo = F,
                                              poly_coef = rep(0,2),
                                              nits_max = Inf)
  samples <- gen_samples(zigzag_fit$positions, zigzag_fit$times,
                         theta = zigzag_fit$thetas, nsample = iters)
  triangle <- sapply(1:iters, function(i){
    g_1 <- grad_log_prob(stan_fit_eval, c(samples$samples[1:p,i],1))
    g_0 <- grad_log_prob(stan_fit_eval, c(samples$samples[1:p,i],0))
    
    return(-attr(g_1,"log_prob") + attr(g_0,"log_prob") + data_cts$log_zeta)
  })
  w_1 <- triangle/(exp(triangle) - 1); w_1_norm <- w_1/sum(w_1)
  
  save(w_1, w_1_norm, samples, zigzag_fit,
       file = paste0("bm/results/rbm_alpha_",alpha_1,"_iter_",rep_1,".Rdata"))
  
  
} else {
  if(alpha_1 == 1){
    set.seed(N_index);zigzag_fit <- zigzag_temp(max_events = iters,
                                                x0 = c(x_init,1),
                                                theta0 = c(theta_init,0),
                                                alphas = c(0, alpha_1), tau_max = 1,
                                                poly_order = length(poly_coef), echo = F,
                                                poly_coef = poly_coef,
                                                nits_max = Inf)
  } else {
    set.seed(N_index);zigzag_fit <- zigzag_temp(max_events = iters,
                                                x0 = c(x_init,.01),
                                                theta0 = c(theta_init,1),
                                                alphas = c(0, alpha_1), tau_max = 1,
                                                poly_order = length(poly_coef), echo = F,
                                                poly_coef = poly_coef,
                                                nits_max = Inf)
  }
  

  save(zigzag_fit,
       file = paste0("bm/results/rbm_alpha_",alpha_1,"_iter_",rep_1,".Rdata"))
}

